//
// Created by Filip on 14/12/2025.
//
#include <algorithm>
#include <complex>
#include <iostream>
#include <map>
#include <numeric>
#include <vector>
using namespace std;

struct item
{
    item(int v, int w, int i)
        : v(v),
          w(w),
          i(i)
    {
        density = static_cast<double>(v)/static_cast<double>(w);
    }

    int v;
    int w;
    int i;
    double density;
    bool operator<(const item& o) const
    {
        return density < o.density;
    }
};

int main()
{
    int N, W;
    float e;
    cin >> N >> W;
    cin >> e;
    vector<item> items;
    for (int i = 0; i < N; i++)
    {
        int t1, t2;
        cin >> t1 >> t2;
        items.emplace_back(t1, t2, i);
    }
    sort(items.begin(), items.end());
    vector<item> chosen_items;
    int cw = 0;
    for (int i = 0; i < N; i++)
    {
        cw += items[i].w;
        if (cw > W)
            break;
        chosen_items.push_back(items[i]);
    }

    cout << chosen_items.size() << endl;
    for (auto & chosen_item : chosen_items)
        cout << chosen_item.i << "";
    cout << endl;

}